#################################################################
### Funksjon for  slette virtuelle maskiner.                 ###

# Add-PSSnapin for SCVMM.
try {
    # Test for snapin og tilkobling til vmm-server
    Add-PSSnapin microsoft.systemcenter.virtualmachinemanager
    Get-VMMServer -ComputerName scvmm
}
catch {
}

# Angi Host - Repeter inntil gyldig
$hostname = $Null

while ($hostname -eq $Null) {
Write-Host "`n`nHostnames:"
    Get-VMHost | select name
    $t = Read-Host "`nAngi hostnavn eller ipadresse "
    $hostname = Get-VMhost -computername $t | Get-VM
}


# Funksjonshode med maskinserie som innargument
function RemVM-by-name ($nameser) {

    # Avbryt hvis navn ikke er angitt
    if ($nameser -eq $null -or $nameser -eq "") {
        Throw "Ingen maskinnavn gitt!"
    }

    # Hente host Informasjon - statisk
    $VMHost = Get-VMHost -VMMServer SCVMM | where {$_.Name -eq $hostname}
    
    # Henter maskiner
    $machines = Get-VM -name ($nameser+"*")
    
    # Tester variabelen $machines for innhold.
    if (-not $machines) {
        Throw "Ingen maskiner med gitt navn eksisterer."
    }
    
    foreach ($item in $machines) {
        Write-host ("Sletter maskin " + $item.name)
        
        # Fjerner maskin fra $machines
        Remove-VM -RunAsynchronously -VM  $item
    }
    
    Write-Host ("" + $machines.count + " maskiner fjernet.")
}

# Funksjonshode med maskinserie som innargument
function RemVM-by-status ($status) {

    # Avbryt hvis navn ikke er angitt
    if ($status -eq $null -or $status -eq "") {
        Throw "Ingen status gitt!"
    }

    # Hente host Informasjon - statisk
    $VMHost = Get-VMHost -VMMServer SCVMM | where {$_.Name -eq $hostname}
    
    # Henter maskiner
    $machines = get-vm | where {$_.status.toString().toLower() -eq $status}
    
    # Tester variabelen $machines for innhold.
    if (-not $machines) {
        Throw "Ingen maskiner med gitt status. Status = " + $status
    }
    
    foreach ($item in $machines) {
        Write-host ("Sletter maskin " + $item.name)
        
        # Fjerner maskin fra $machines
        Remove-VM -RunAsynchronously -VM  $item
    }
    
    Write-Host ("" + $machines.count + " maskiner fjernet.")
}
